﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>


<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=unicode">
	<title>Zestawienie księgowe</title>

	<script runat="server">
    
		private void ZestawienieKsiegowe_OnLoad(Object sender, EventArgs args)
		{
			OkresObrachunkowy o = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
            WynikZestKS w = null;
            if (DataContext1.Context.Contains(typeof (WynikZestKS)))
            {
                w = (WynikZestKS) DataContext1.Get(typeof (WynikZestKS));
            }
            ZestawienieKS z;
            if (w != null)
                z = w.Zestawienie;
            else
                z = (ZestawienieKS) DataContext1.Get(typeof (ZestawienieKS));
            ZestawieniaKS.Params p = new ZestawieniaKS.Params(DataContext1.Context);
            if (DataContext1.Context.Contains(typeof (ZestawieniaKS.Params)))
                p = (ZestawieniaKS.Params) DataContext1.Get(typeof (ZestawieniaKS.Params));
			ReportHeader1.Title = z.Nazwa;
			if (p.Okres != FromTo.All)
				ReportHeader1.Title += " za okres " + p.Okres.ToString();

			cc = ColumnsCreator.Init(z, o, p, Param);
			cc.initColumns(GridAkt, true);
			cc.initColumns(GridPas, false);
		}


		private ColumnsCreator cc = null;


		private class ColumnsCreator
		{
			private readonly ZestawienieKS.Wynik Wynik;
			private readonly Params printParams;


			public ColumnsCreator(ZestawienieKS.Wynik wynik, Params printParams)
			{
				this.Wynik = wynik;
				this.printParams = printParams;
			}


			public static ColumnsCreator Init(ZestawienieKS zestawienie, OkresObrachunkowy okres, ZestawieniaKS.Params param, Params printParams)
			{ return new ColumnsCreator(printParams.Wynik == null ? zestawienie.ObliczZestawienie(okres, param) : ZestawienieKS.Wynik.Deserialize(printParams.Wynik), printParams); }


			public void initColumns(Grid grid, Boolean aktywa)
			{
				int iloscKomorek = Wynik.Kolumny.Length;

				GridColumn col = null;
				col = new GridColumn();
				col.Caption = "Numer";
				col.Width = 15;
				col.RowSpan = grid.RowsInRow;
				grid.Columns.Add(col);

				col = new GridColumn();
				col.Caption = "Opis";
				col.RowSpan = grid.RowsInRow;
				grid.Columns.Add(col);

				foreach (ZestawienieKS.Wynik.Kolumna kol in Wynik.Kolumny)
				{
					col = new GridColumn();
					col.Caption = kol.Tytul;
					col.Width = 18;
					col.Format = "{0:n}";
					col.Align = HorizontalAlign.Right;
					col.HideZero = true;
					col.EncodeHTML = false;
					grid.Columns.Add(col);
					iloscKomorek--;
				}

				while (iloscKomorek > 0)
				{
					col = new GridColumn();
					col.Caption = "";
					grid.Columns.Add(col);
					iloscKomorek--;
				}

				grid.DataSource = aktywa ? Aktywa : Pasywa;
			}


			private IEnumerable<ZestawienieKS.Pozycja> Aktywa
			{
				get
				{
					foreach (ZestawienieKS.Pozycja p in Wynik.Pozycje)
					{
						if (p.Symbol.Trim().StartsWith("1"))
							yield return p;
					}
				}
			}

			private IEnumerable<ZestawienieKS.Pozycja> Pasywa
			{
				get
				{
					foreach (ZestawienieKS.Pozycja p in Wynik.Pozycje)
						if (p.Symbol.Trim().StartsWith("2"))
							yield return p;
				}
			}
		}


		private void OnBeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			Grid grid = (Grid)sender;

			ZestawienieKS.Pozycja poz = (ZestawienieKS.Pozycja)args.Row;
			PozycjaZestKS p = (PozycjaZestKS)KsiegaModule.GetInstance(poz.Wynik.Zestawienie).PozycjeZestKS.WgZestawienie[poz.Wynik.Zestawienie, poz.Symbol].GetPrev();

			String format = "{0}";
			String formatNum = "{0:n}";
			if (p != null && p.Symbol.Count(ch => ch == '.') <= 2)
			{
				format = "<B>{0}</B>";
				formatNum = "<B>{0:n}</B>";
			}

			grid.Columns[0].EditValue = string.Format(format, numerOstatniSegment(encode(poz.Numer)));
			grid.Columns[1].EditValue = string.Format(format, encode(poz.Opis).Replace(" ", "&nbsp;"));

			for (int i = 0; i < poz.Komorki.Count; i++)
			{
				if (Param.PokazInfoSkrocone && poz[i].InfoSkrocone != "Brak")
				{
					grid.Columns[i + 2].Align = HorizontalAlign.Left;
					String s = String.Empty;

					string[] sa = poz[i].InfoSkrocone.Split(';');
					for (int j = 0; j < sa.Length; j++)
						s += sa[j].Trim() + (j < sa.Length - 1 ? "\n" : "");

					grid.Columns[i + 2].EditValue = String.Format("Wartość: {0}\n{1}", String.Format(formatNum, poz[i].Wartosc), s);
				}
				else
				{
					grid.Columns[i + 2].Format = formatNum;
					grid.Columns[i + 2].Align = HorizontalAlign.Right;
					grid.Columns[i + 2].EditValue = poz[i].Wartosc;
				}
			}
		}


		public static String encode(String s)
		{ return HttpUtility.HtmlEncode(s); }


		private String numerOstatniSegment(String numer)
		{
			if (!Param.TylkoOstatniSegmentNumeru)
				return numer;

			int i = numer.LastIndexOf(".");
			if (i < 0) return numer;

			int j = i + 1;
			string s = "";
			while (j > 0)
			{
				s += "&nbsp;";
				j--;
			}

			return s + numer.Substring(i + 1);
		}


		[Context]
		public Params Param
		{ get; set; }


		public class Params : ContextBase
		{
			private ZestawienieKS zestawienie = null;
			private WynikZestKS wynik = null;
			private Boolean tylkoOstatniSegmentNumeru = false;
			private Boolean pokazInfoSkrocone = false;


			public Params(Context cx)
				: base(cx)
			{
				if (cx.Contains(typeof (ZestawienieKS)))
                {
                    zestawienie = (ZestawienieKS) cx[typeof (ZestawienieKS)];
                }
                if (cx.Contains(typeof (WynikZestKS)))
                {
                    wynik = (WynikZestKS) cx[typeof (WynikZestKS)];
                    zestawienie = wynik.Zestawienie;
                }
			}


			[Priority(10)]
			[Caption("Zapisany wynik")]
			public WynikZestKS Wynik
			{
				get { return wynik; }
				set { wynik = value; }
			}

			public object GetListWynik()
			{ return zestawienie.Wyniki; }


			[Priority(20)]
			[Caption("Tylko ostatni segment numeru")]
			public bool TylkoOstatniSegmentNumeru
			{
				get { return tylkoOstatniSegmentNumeru; }
				set { tylkoOstatniSegmentNumeru = value; }
			}


			[Priority(30)]
			[Caption("Pokaż skrócone info")]
			public bool PokazInfoSkrocone
			{
				get { return pokazInfoSkrocone; }
				set { pokazInfoSkrocone = value; }
			}
		}

	</script>

</head>
<body>
	<form id="ZestawienieKsiegowe" method="post" runat="server" onload="ZestawienieKsiegowe_OnLoad">
		<ea:datacontext id="DataContext1" runat="server"/>
		<cc1:ReportHeader id="ReportHeader1" runat="server" />

		<div style="height: 5mm;">&nbsp;</div>
		<ea:grid id="GridAkt" runat="server" OnBeforeRow="OnBeforeRow" />
		<div style="height: 7mm;">&nbsp;</div>
		<ea:grid id="GridPas" runat="server" OnBeforeRow="OnBeforeRow" />

		<div style="height: 32mm;">&nbsp;</div>
		<div style="font-size: 8pt;">
			<div style="float: left; width: 8cm; text-align: center; border-top: 1px dotted black;">
				imię i nazwisko osoby<br />
				której powierzono prowadzenie ksiąg rachunkowych
			</div>
			<div style="float: right; width: 8cm; text-align: center; border-top: 1px dotted black;">
				imię, nazwisko i podpisy kierownika jednostki, a jeżeli jednostką kieruje organ wieloosobowy, wszystkich członków tego organu
			</div>
		</div>

		<div style="height: 15mm;">&nbsp;</div>
		<cc1:ReportFooter id="ReportFooter2" runat="server">
			<subtitles>
	          <cc1:FooterSubtitle SubtitleType="Operator" Width="24" />
	        </subtitles>
		</cc1:ReportFooter>
	</form>
</body>
</html>

